% objective: find the exchange coefficient of five key pathways based on
% dFBA simulation and 13C labeling information
% Author: Xueyang Feng (fengx@seas.wustl.edu)
% date: 09/01/2011

function [f,exIDV_Ala,exIDV_Ser,exIDV_Gly,exIDV_Asp,exIDV_Glu]=final_13C_dFBA(var,exch)

num_time=12*34;

X=zeros(409,1)+4.5738e-04;

%% initialize LACText, PYRext, ACText
LACText000=0.02;
LACText001=0.98;
LACText010=0;
LACText011=0;
LACText100=0;
LACText101=0;
LACText110=0;
LACText111=0;
PYRext000=1;
PYRext001=0;
PYRext010=0;
PYRext011=0;
PYRext100=0;
PYRext101=0;
PYRext110=0;
PYRext111=0;
ACText00=1;
ACText01=0;
ACText10=0;
ACText11=0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% initialize sum
sum_flux_pyr=0;
sum_isotope_pyr000=0;
sum_isotope_pyr001=0;
sum_isotope_pyr010=0;
sum_isotope_pyr011=0;
sum_isotope_pyr100=0;
sum_isotope_pyr101=0;
sum_isotope_pyr110=0;
sum_isotope_pyr111=0;
sum_flux_act=0;
sum_isotope_act00=0;
sum_isotope_act01=0;
sum_isotope_act10=0;
sum_isotope_act11=0;
sum_flux_ser=0;
sum_isotope_SerM0=0;
sum_isotope_SerM1=0;
sum_isotope_SerM2=0;
sum_isotope_SerM3=0;
sum_isotope_Ser159M0=0;
sum_isotope_Ser159M1=0;
sum_isotope_Ser159M2=0;
sum_flux_ala=0;
sum_isotope_AlaM0=0;
sum_isotope_AlaM1=0;
sum_isotope_AlaM2=0;
sum_isotope_AlaM3=0;
sum_isotope_Ala159M0=0;
sum_isotope_Ala159M1=0;
sum_isotope_Ala159M2=0;
sum_flux_leu=0;
sum_isotope_Leu159M0=0;
sum_isotope_Leu159M1=0;
sum_isotope_Leu159M2=0;
sum_isotope_Leu159M3=0;
sum_flux_asp=0;
sum_isotope_AspM0=0;
sum_isotope_AspM1=0;
sum_isotope_AspM2=0;
sum_isotope_AspM3=0;
sum_isotope_AspM4=0;
sum_isotope_Asp159M0=0;
sum_isotope_Asp159M1=0;
sum_isotope_Asp159M2=0;
sum_isotope_Asp159M3=0;
sum_flux_glu=0;
sum_isotope_GluM0=0;
sum_isotope_GluM1=0;
sum_isotope_GluM2=0;
sum_isotope_GluM3=0;
sum_isotope_GluM4=0;
sum_isotope_GluM5=0;
sum_isotope_Glu159M0=0;
sum_isotope_Glu159M1=0;
sum_isotope_Glu159M2=0;
sum_isotope_Glu159M3=0;
sum_flux_gly=0;
sum_isotope_GlyM0=0;
sum_isotope_GlyM1=0;
sum_isotope_GlyM2=0;
sum_isotope_Gly159=0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% initialize exIDV
exIDV_ACT=zeros(4,num_time);
exIDV_PYR=zeros(8,num_time);
exIDV_Ala=zeros(4,num_time);
exIDV_Ser=zeros(4,num_time);
exIDV_Gly=zeros(3,num_time);
exIDV_Asp=zeros(5,num_time);
exIDV_Glu=zeros(6,num_time);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

start_time=1;
for i=1:408
    if(sum(var(:,i).^2)==0)
        start_time=start_time+1;
    end
end

for time=start_time:num_time 
    %% assign flux to corresponding pathways
    J_4HBTE=var(1,time);
    J_5DOAN=var(2,time);
    J_A5PISO=var(3,time);
    J_AACPS10=var(4,time);
    J_AACPS11=var(5,time);
    J_AACPS12=var(6,time);
    J_AACPS13=var(7,time);
    J_AACPS14=var(8,time);
    J_AACPS15=var(9,time);
    J_AACPS3=var(10,time);
    J_AACPS4=var(11,time);
    J_AACPS5=var(12,time);
    J_AACPS6=var(13,time);
    J_AACPS7=var(14,time);
    J_AACPS8=var(15,time);
    J_AACPS9=var(16,time);
    J_ABTA=var(17,time);
    J_ACACCT=var(18,time);
    J_ACALDi=var(19,time);
    J_ACBIPGT=var(20,time);
    J_ACCOAC=var(21,time);
    J_ACCOAL=var(22,time);
    J_ACGAMK=var(23,time);
    J_ACGAt2=var(24,time);
    J_ACGK=var(25,time);
    J_ACGS=var(26,time);
    J_ACHBS=var(27,time);
    J_ACKr=var(28,time);
    J_ACLS=var(29,time);
    J_ACMAT1=var(30,time);
    J_ACOAD8=var(31,time);
    J_ACOATA=var(32,time);
    J_ACODA=var(33,time);
    J_ACONT=var(34,time);
    J_ACOTA=var(35,time);
    J_ACPS1=var(36,time);
    J_ACPSc=var(37,time);
    J_ACS=var(38,time);
    J_ACt6=var(39,time);
    J_ADA=var(40,time);
    J_ADCL=var(41,time);
    J_ADCOBAK=var(42,time);
    J_ADCOBAS=var(43,time);
    J_ADCOBHEXS=var(44,time);
    J_ADCS=var(45,time);
    J_ADK1=var(46,time);
    J_ADK3=var(47,time);
    J_ADK4=var(48,time);
    J_ADMDC=var(49,time);
    J_ADNCYC=var(50,time);
    J_ADNK1=var(51,time);
    J_ADNt2=var(52,time);
    J_ADPT=var(53,time);
    J_ADSK=var(54,time);
    J_ADSL1r=var(55,time);
    J_ADSL2r=var(56,time);
    J_ADSS=var(57,time);
    J_AGDC=var(58,time);
    J_AGPR=var(59,time);
    J_AHAI=var(60,time);
    J_AHCYSNS=var(61,time);
    J_AHSERL=var(62,time);
    J_AHSERL2=var(63,time);
    J_AICART=var(64,time);
    J_AIRC2=var(65,time);
    J_AIRC3=var(66,time);
    J_AKGD=var(67,time);
    J_AKGt6=var(68,time);
    J_ALA_Dt4=var(69,time);
    J_ALAALA=var(70,time);
    J_ALAD_L=var(71,time);
    J_ALAR=var(72,time);
    J_ALAt4=var(73,time);
    J_ALATA_D2=var(74,time);
    J_ALATA_L=var(75,time);
    J_ALATA_L2=var(76,time);
    J_ALATRS=var(77,time);
    J_ALCD2x=var(78,time);
    J_ALDD2x=var(79,time);
    J_AMAA=var(80,time);
    J_AMALT1=var(81,time);
    J_AMALT2=var(82,time);
    J_AMALT3=var(83,time);
    J_AMALT4=var(84,time);
    J_AMAOT=var(85,time);
    J_AMMQT7_2=var(86,time);
    J_AMMQT7_3=var(87,time);
    J_AMPMS=var(88,time);
    J_ANPRT=var(89,time);
    J_ANS1=var(90,time);
    J_AOXS=var(91,time);
    J_AP4AH=var(92,time);
    J_AP5AH=var(93,time);
    J_APRAUR=var(94,time);
    J_ARGabc=var(95,time);
    J_ARGDC=var(96,time);
    J_ARGSL=var(97,time);
    J_ARGSS=var(98,time);
    J_ARGTRS=var(99,time);
    J_ARSRD2=var(100,time);
    J_ARSt=var(101,time);
    J_ARSt1=var(102,time);
    J_ASAD=var(103,time);
    J_ASNN=var(104,time);
    J_ASNS1=var(105,time);
    J_ASNTRS=var(106,time);
    J_ASP1DC=var(107,time);
    J_ASPCT=var(108,time);
    J_ASPK=var(109,time);
    J_ASPO3=var(110,time);
    J_ASPO5=var(111,time);
    J_ASPO6=var(112,time);
    J_ASPO8=var(113,time);
    J_ASPO9=var(114,time);
    J_ASPt2_3=var(115,time);
    J_ASPTA1=var(116,time);
    J_ASPTA4=var(117,time);
    J_ASPTRS=var(118,time);
    J_AST=var(119,time);
    J_ATPM=var(120,time);
    J_ATPPRT=var(121,time);
    J_ATPS4r=var(122,time);
    J_BPNT=var(123,time);
    J_BTS2=var(124,time);
    J_C120SN=var(125,time);
    J_C130ISN=var(126,time);
    J_C140ISN=var(127,time);
    J_C140SN=var(128,time);
    J_C150ISN=var(129,time);
    J_C150SN=var(130,time);
    J_C151SN=var(131,time);
    J_C160ISN=var(132,time);
    J_C160SN=var(133,time);
    J_C161SN=var(134,time);
    J_C170ISN=var(135,time);
    J_C170SN=var(136,time);
    J_C171SN=var(137,time);
    J_C180SN=var(138,time);
    J_C181SN=var(139,time);
    J_C50SN=var(140,time);
    J_C60ISN=var(141,time);
    J_C70ISN=var(142,time);
    J_CAT=var(143,time);
    J_CAt4i=var(144,time);
    J_CBIAT=var(145,time);
    J_CBL1abc=var(146,time);
    J_CBLAT=var(147,time);
    J_CBLTR3=var(148,time);
    J_CBLTR4=var(149,time);
    J_CBPS=var(150,time);
    J_CDPMEK=var(151,time);
    J_CHORM=var(152,time);
    J_CHORS=var(153,time);
    J_CHRPL=var(154,time);
    J_CKDOAS=var(155,time);
    J_CLAT=var(156,time);
    J_Clt=var(157,time);
    J_CMLDC=var(158,time);
    J_CO2t=var(159,time);
    J_COBALTt3=var(160,time);
    J_COBALTt5=var(161,time);
    J_COBPS=var(162,time);
    J_CONFALDD=var(163,time);
    J_CPPPGO=var(164,time);
    J_CPPPGOAN=var(165,time);
    J_CRMR=var(166,time);
    J_CRMR2=var(167,time);
    J_CRMR3=var(168,time);
    J_CRO4t6=var(169,time);
    J_CS=var(170,time);
    J_CSND=var(171,time);
    J_CTPS2=var(172,time);
    J_Cut1=var(173,time);
    J_CYCPOe=var(174,time);
    J_CYOO2=var(175,time);
    J_CYOR7=var(176,time);
    J_CYSS=var(177,time);
    J_CYSt2=var(178,time);
    J_CYSTL=var(179,time);
    J_CYSTRS=var(180,time);
    J_CYTBD=var(181,time);
    J_CYTD=var(182,time);
    J_CYTDK1=var(183,time);
    J_CYTDK2=var(184,time);
    J_CYTDK3=var(185,time);
    J_CYTDt2=var(186,time);
    J_CYTK1=var(187,time);
    J_CYTK2=var(188,time);
    J_DADA=var(189,time);
    J_DADK=var(190,time);
    J_DADNt2=var(191,time);
    J_DAGK=var(192,time);
    J_DAHPS=var(193,time);
    J_DAPDC=var(194,time);
    J_DAPE=var(195,time);
    J_DASYN=var(196,time);
    J_DB4PS=var(197,time);
    J_DBTSr=var(198,time);
    J_DCTPD=var(199,time);
    J_DCYTD=var(200,time);
    J_DCYTt2=var(201,time);
    J_DGK1=var(202,time);
    J_DGTPH=var(203,time);
    J_DHAD1=var(204,time);
    J_DHAD2=var(205,time);
    J_DHDPRy=var(206,time);
    J_DHDPS=var(207,time);
    J_DHFR=var(208,time);
    J_DHFS=var(209,time);
    J_DHNAOT7=var(210,time);
    J_DHNPA=var(211,time);
    J_DHORD2=var(212,time);
    J_DHORD4i=var(213,time);
    J_DHORD8=var(214,time);
    J_DHORTS=var(215,time);
    J_DHPPDA2=var(216,time);
    J_DHPRx=var(217,time);
    J_DHPS3=var(218,time);
    J_DHQD1=var(219,time);
    J_DHQS=var(220,time);
    J_DIPEPabc10=var(221,time);
    J_DIPEPabc13=var(222,time);
    J_DKMPPD=var(223,time);
    J_DKMPPD2=var(224,time);
    J_D_LACt2=var(225,time);
    J_DMATT=var(226,time);
    J_DMOCT=var(227,time);
    J_DMPPS=var(228,time);
    J_DMQMT=var(229,time);
    J_DMSOR3e=var(230,time);
    J_DMSOR4e=var(231,time);
    J_DNASYN_Son=var(232,time);
    J_DNMPPA=var(233,time);
    J_DNTPPA=var(234,time);
    J_DPCOAK=var(235,time);
    J_DPR=var(236,time);
    J_DRBK=var(237,time);
    J_DRPA=var(238,time);
    J_DTMPK=var(239,time);
    J_DURIK1=var(240,time);
    J_DURIPP=var(241,time);
    J_DURIt2=var(242,time);
    J_DUTPDP=var(243,time);
    J_DXPRI=var(244,time);
    J_DXPS=var(245,time);
    J_E4PD=var(246,time);
    J_EDA=var(247,time);
    J_EDTXS5=var(248,time);
    J_EDTXS6=var(249,time);
    J_ENO=var(250,time);
    J_EPPP2=var(251,time);
    J_ETOHt1=var(252,time);
    J_FAO5=var(253,time);
    J_FAO6=var(254,time);
    J_FAO7=var(255,time);
    J_FBA=var(256,time);
    J_FBP=var(257,time);
    J_FCLT=var(258,time);
    J_FDH10=var(259,time);
    J_FDH9=var(260,time);
    J_FE2abc=var(261,time);
    J_FE3abc=var(262,time);
    J_FER3=var(263,time);
    J_FER4=var(264,time);
    J_FGLU=var(265,time);
    J_FHLe=var(266,time);
    J_FMETTRS=var(267,time);
    J_FMNAT=var(268,time);
    J_FMNRx=var(269,time);
    J_FNOR=var(270,time);
    J_FORt=var(271,time);
    J_FRD8=var(272,time);
    J_FRD9=var(273,time);
    J_FRMDt=var(274,time);
    J_FRTT=var(275,time);
    J_FTHFD=var(276,time);
    J_FTHFL=var(277,time);
    J_FUM=var(278,time);
    J_FUMACA=var(279,time);
    J_FUMt2_2=var(280,time);
    J_FUMt4=var(281,time);
    J_G1PACT=var(282,time);
    J_G1PTMT=var(283,time);
    J_G1SATi=var(284,time);
    J_G35DP=var(285,time);
    J_G3PD2=var(286,time);
    J_G3PD4=var(287,time);
    J_G3PD8=var(288,time);
    J_G5SADs=var(289,time);
    J_G5SD=var(290,time);
    J_G6PDA=var(291,time);
    J_G6PDHy=var(292,time);
    J_GALKr=var(293,time);
    J_GALU=var(294,time);
    J_GAPD=var(295,time);
    J_GARFT=var(296,time);
    J_GART=var(297,time);
    J_GBEZ=var(298,time);
    J_GCALDD=var(299,time);
    J_GF6PTA=var(300,time);
    J_GGLUGABDH=var(301,time);
    J_GGLUGABH=var(302,time);
    J_GGLUPTO=var(303,time);
    J_GGLUPTS=var(304,time);
    J_GGTT=var(305,time);
    J_GHMT=var(306,time);
    J_GK1=var(307,time);
    J_GLCGSD=var(308,time);
    J_GLCP=var(309,time);
    J_GLCS1=var(310,time);
    J_GLCURE=var(311,time);
    J_GLGC=var(312,time);
    J_GLNS=var(313,time);
    J_GLNt2=var(314,time);
    J_GLNTRS=var(315,time);
    J_GLU5K=var(316,time);
    J_GLUCYSL=var(317,time);
    J_GLUDx=var(318,time);
    J_GLUN=var(319,time);
    J_GLUPRT=var(320,time);
    J_GLUR=var(321,time);
    J_GLUSy=var(322,time);
    J_GLUt2=var(323,time);
    J_GLUt4i=var(324,time);
    J_GLUTRR=var(325,time);
    J_GLUTRS=var(326,time);
    J_GLYAT=var(327,time);
    J_GLYCKb=var(328,time);
    J_GLYCL=var(329,time);
    J_GLYCLTDxr=var(330,time);
    J_GLYCLTt2r=var(331,time);
    J_GLYCRt2=var(332,time);
    J_GLYD=var(333,time);
    J_GLYK=var(334,time);
    J_GLYOX=var(335,time);
    J_GLYt4=var(336,time);
    J_GLYTRS=var(337,time);
    J_GMHEPAT=var(338,time);
    J_GMHEPK=var(339,time);
    J_GMHEPPA=var(340,time);
    J_GMPS2=var(341,time);
    J_GP4GH=var(342,time);
    J_GPDDA2=var(343,time);
    J_GPDDA4=var(344,time);
    J_GRTT=var(345,time);
    J_GSHPO=var(346,time);
    J_GSNK=var(347,time);
    J_GTHRD=var(348,time);
    J_GTHRDabc=var(349,time);
    J_GTHS=var(350,time);
    J_GTPCI=var(351,time);
    J_GTPCII=var(352,time);
    J_GTPDPK=var(353,time);
    J_GUAPRT=var(354,time);
    J_H2Ot5=var(355,time);
    J_HACOADr=var(356,time);
    J_HBUTCT=var(357,time);
    J_HBZOPT=var(358,time);
    J_HCO3E=var(359,time);
    J_HDCAt2=var(360,time);
    J_HEMEOS=var(361,time);
    J_HEPTT=var(362,time);
    J_HEXTT=var(363,time);
    J_HGENDO=var(364,time);
    J_HGt=var(365,time);
    J_HISD1=var(366,time);
    J_HISTD=var(367,time);
    J_HISTP=var(368,time);
    J_HISTRS=var(369,time);
    J_HMBS=var(370,time);
    J_HMGDx=var(371,time);
    J_HMGL=var(372,time);
    J_HMGSs=var(373,time);
    J_HOXPRx=var(374,time);
    J_HPPDO1=var(375,time);
    J_HPPK=var(376,time);
    J_HSDy=var(377,time);
    J_HSK=var(378,time);
    J_HSST=var(379,time);
    J_HSTPT=var(380,time);
    J_HTHBPD=var(381,time);
    J_HXAD=var(382,time);
    J_HXPRT=var(383,time);
    J_HYD5i=var(384,time);
    J_HYD6i=var(385,time);
    J_ICDHxi=var(386,time);
    J_ICDHy=var(387,time);
    J_ICHORSi=var(388,time);
    J_ICL=var(389,time);
    J_IG3PS=var(390,time);
    J_IGPDH=var(391,time);
    J_IGPS=var(392,time);
    J_ILEDH2=var(393,time);
    J_ILEt4=var(394,time);
    J_ILETA=var(395,time);
    J_ILETRS=var(396,time);
    J_IMPC=var(397,time);
    J_IMPD=var(398,time);
    J_INDOLEt2=var(399,time);
    J_INSK=var(400,time);
    J_INSt2=var(401,time);
    J_IPDPS=var(402,time);
    J_IPMD=var(403,time);
    J_IPPMIa=var(404,time);
    J_IPPMIb=var(405,time);
    J_IPPS=var(406,time);
    J_IZPN=var(407,time);
    J_KARA2i=var(408,time);
    J_KAS15=var(409,time);
    J_KAS16=var(410,time);
    J_KDOPP=var(411,time);
    J_KDOPS=var(412,time);
    J_Kt2i=var(413,time);
    J_Kt3=var(414,time);
    J_LDH_D2=var(415,time);
    J_LDH_D4=var(416,time);
    J_LDH_D5=var(417,time);
    J_LDH_Dir=var(418,time);
    J_LEUt4=var(419,time);
    J_LEUTA=var(420,time);
    J_LEUTRS=var(421,time);
    J_LGTHL=var(422,time);
    J_L_LACD2=var(423,time);
    J_L_LACD4=var(424,time);
    J_L_LACD5=var(425,time);
    J_L_LACt2=var(426,time);
    J_LLEUDr=var(427,time);
    J_LPADSS=var(428,time);
    J_LPSSYN_SO=var(429,time);
    J_LYSt3=var(430,time);
    J_LYSTRS=var(431,time);
    J_MACPD=var(432,time);
    J_MALS=var(433,time);
    J_MALt2_2=var(434,time);
    J_MALt2_3=var(435,time);
    J_MALTAT=var(436,time);
    J_MALTK=var(437,time);
    J_MCAL=var(438,time);
    J_MCCC=var(439,time);
    J_MCITD=var(440,time);
    J_MCITS=var(441,time);
    J_MCOATA=var(442,time);
    J_MCPST=var(443,time);
    J_MDH=var(444,time);
    J_MDRPD=var(445,time);
    J_ME2=var(446,time);
    J_MEAMP1_gly_asp=var(447,time);
    J_MEAMP1_gly_glu=var(448,time);
    J_MECDPDH=var(449,time);
    J_MECDPS=var(450,time);
    J_MEPCT=var(451,time);
    J_METAT=var(452,time);
    J_METGL=var(453,time);
    J_METS=var(454,time);
    J_METTRS=var(455,time);
    J_MGCH=var(456,time);
    J_MGt3=var(457,time);
    J_MGt5=var(458,time);
    J_MI1PP=var(459,time);
    J_MICITH=var(460,time);
    J_MICITL=var(461,time);
    J_MLACI=var(462,time);
    J_MMSDHir=var(463,time);
    J_MNOR=var(464,time);
    J_MNOR2=var(465,time);
    J_MOAT3=var(466,time);
    J_MOBDabc=var(467,time);
    J_MOHMT=var(468,time);
    J_MTAN=var(469,time);
    J_MTHFC=var(470,time);
    J_MTHFD=var(471,time);
    J_MTHFR2=var(472,time);
    J_MTRI=var(473,time);
    J_MTRK=var(474,time);
    J_NAabcO=var(475,time);
    J_NADH11=var(476,time);
    J_NADH12=var(477,time);
    J_NADH13=var(478,time);
    J_NADH14=var(479,time);
    J_NADH16=var(480,time);
    J_NADH4=var(481,time);
    J_NADK=var(482,time);
    J_NADS1=var(483,time);
    J_NAt3=var(484,time);
    J_NAt3_2=var(485,time);
    J_NAt9=var(486,time);
    J_NCTPPRT=var(487,time);
    J_NDPK1=var(488,time);
    J_NDPK2=var(489,time);
    J_NDPK3=var(490,time);
    J_NDPK4=var(491,time);
    J_NDPK5=var(492,time);
    J_NDPK6=var(493,time);
    J_NDPK7=var(494,time);
    J_NDPK8=var(495,time);
    J_NH4t=var(496,time);
    J_NIt3=var(497,time);
    J_NMNAT=var(498,time);
    J_NMNP=var(499,time);
    J_NNAT=var(500,time);
    J_NNDMBRT=var(501,time);
    J_NNDMBRT2=var(502,time);
    J_NNDPR=var(503,time);
    J_NPHS=var(504,time);
    J_NTD1=var(505,time);
    J_NTD10=var(506,time);
    J_NTD11=var(507,time);
    J_NTD2=var(508,time);
    J_NTD3=var(509,time);
    J_NTD4=var(510,time);
    J_NTD5=var(511,time);
    J_NTD6=var(512,time);
    J_NTD7=var(513,time);
    J_NTD8=var(514,time);
    J_NTD9=var(515,time);
    J_NTPP1=var(516,time);
    J_NTPP2=var(517,time);
    J_NTPP3=var(518,time);
    J_NTPP4=var(519,time);
    J_NTPP5=var(520,time);
    J_NTPP6=var(521,time);
    J_NTPP7=var(522,time);
    J_NTPP8=var(523,time);
    J_NTR4=var(524,time);
    J_NTR5=var(525,time);
    J_NTRIRmmq2=var(526,time);
    J_NTRIRmq2=var(527,time);
    J_O2t=var(528,time);
    J_OBTFL=var(529,time);
    J_OCBT=var(530,time);
    J_OCDCAt2=var(531,time);
    J_OHPBAT=var(532,time);
    J_OHPHM=var(533,time);
    J_OIVD1i=var(534,time);
    J_OIVD2=var(535,time);
    J_OIVD3=var(536,time);
    J_OMBZLM=var(537,time);
    J_OMCDC=var(538,time);
    J_OMMBLHX=var(539,time);
    J_OMPDC=var(540,time);
    J_OMPHHX=var(541,time);
    J_OPHBDC=var(542,time);
    J_OPHHX=var(543,time);
    J_ORNDC=var(544,time);
    J_ORPT=var(545,time);
    J_OXGDC2=var(546,time);
    J_P5CD=var(547,time);
    J_P5CR=var(548,time);
    J_PANTS=var(549,time);
    J_PAP=var(550,time);
    J_PAPPT3=var(551,time);
    J_PAPSR=var(552,time);
    J_PASYN_SO_Aerobic=var(553,time);
    J_PDH=var(554,time);
    J_PDX5PO=var(555,time);
    J_PDX5PS=var(556,time);
    J_PEPTIDOXe=var(557,time);
    J_PERD=var(558,time);
    J_PFL=var(559,time);
    J_PGAMT=var(560,time);
    J_PGCD=var(561,time);
    J_PGDH=var(562,time);
    J_PGDHY=var(563,time);
    J_PGI=var(564,time);
    J_PGK=var(565,time);
    J_PGL=var(566,time);
    J_PGLYCP=var(567,time);
    J_PGM=var(568,time);
    J_PGMT=var(569,time);
    J_PGPPH=var(570,time);
    J_PGSA=var(571,time);
    J_PHE4MO=var(572,time);
    J_PHEAL=var(573,time);
    J_PHETA1=var(574,time);
    J_PHETRS=var(575,time);
    J_PHYT3e=var(576,time);
    J_PIabc=var(577,time);
    J_PIt6=var(578,time);
    J_PLIPPE_SO=var(579,time);
    J_PLIPPG_SO=var(580,time);
    J_PMANM=var(581,time);
    J_PMDPHT=var(582,time);
    J_PMPK=var(583,time);
    J_PNTK=var(584,time);
    J_PPA=var(585,time);
    J_PPAt2=var(586,time);
    J_PPBNGS=var(587,time);
    J_PPC=var(588,time);
    J_PPCDC=var(589,time);
    J_PPCK=var(590,time);
    J_PPM=var(591,time);
    J_PPM2=var(592,time);
    J_PPNCL=var(593,time);
    J_PPND=var(594,time);
    J_PPNDH=var(595,time);
    J_PPPGO=var(596,time);
    J_PPS=var(597,time);
    J_PPTGSe=var(598,time);
    J_PPTT=var(599,time);
    J_PRAGS=var(600,time);
    J_PRAIi=var(601,time);
    J_PRAIS=var(602,time);
    J_PRAMPC=var(603,time);
    J_PRASCS=var(604,time);
    J_PRATPP=var(605,time);
    J_PRFGS=var(606,time);
    J_PRKIN=var(607,time);
    J_PRMICIi=var(608,time);
    J_PRO1q=var(609,time);
    J_PROTRS=var(610,time);
    J_PROTSYN_Son_aerobic=var(611,time);
    J_PRPPS=var(612,time);
    J_PSCVT=var(613,time);
    J_PSD=var(614,time);
    J_PSERT=var(615,time);
    J_PSP_L=var(616,time);
    J_PSSA=var(617,time);
    J_PSUDS=var(618,time);
    J_PTAr=var(619,time);
    J_PTPATi=var(620,time);
    J_PTRCabc=var(621,time);
    J_PTRCORNt7=var(622,time);
    J_PTRCt2=var(623,time);
    J_PUNP1=var(624,time);
    J_PUNP2=var(625,time);
    J_PUNP3=var(626,time);
    J_PUNP4=var(627,time);
    J_PUNP5=var(628,time);
    J_PUNP6=var(629,time);
    J_PUNP7=var(630,time);
    J_PYAM5PO=var(631,time);
    J_PYK=var(632,time);
    J_PYNP2=var(633,time);
    J_PYRt2=var(634,time);
    J_QULNS=var(635,time);
    J_RBFK=var(636,time);
    J_RBFSa=var(637,time);
    J_RBFSb=var(638,time);
    J_RBK=var(639,time);
    J_RBZP=var(640,time);
    J_RHCCE=var(641,time);
    J_RNASYN_Son=var(642,time);
    J_RNDR1=var(643,time);
    J_RNDR2=var(644,time);
    J_RNDR3=var(645,time);
    J_RNDR4=var(646,time);
    J_RNTR1=var(647,time);
    J_RNTR2=var(648,time);
    J_RNTR3=var(649,time);
    J_RNTR4=var(650,time);
    J_RPE=var(651,time);
    J_RPI=var(652,time);
    J_S7PI=var(653,time);
    J_SADH=var(654,time);
    J_SADT2=var(655,time);
    J_SDPDS=var(656,time);
    J_SDPTA=var(657,time);
    J_SELNPS=var(658,time);
    J_SERAT=var(659,time);
    J_SERD_L=var(660,time);
    J_SERt6=var(661,time);
    J_SERTRS=var(662,time);
    J_SFGTH=var(663,time);
    J_SGDS=var(664,time);
    J_SGSAD=var(665,time);
    J_SHCHCS2=var(666,time);
    J_SHCHD2=var(667,time);
    J_SHCHF=var(668,time);
    J_SHK3D=var(669,time);
    J_SHKK=var(670,time);
    J_SHSL1=var(671,time);
    J_SLCYSS=var(672,time);
    J_SO3De=var(673,time);
    J_SO3R2=var(674,time);
    J_SO3R3=var(675,time);
    J_SO4t2=var(676,time);
    J_SOD=var(677,time);
    J_SOTA=var(678,time);
    J_SPA=var(679,time);
    J_SPMS=var(680,time);
    J_SPRS=var(681,time);
    J_SSALx=var(682,time);
    J_SUCBZL=var(683,time);
    J_SUCBZS=var(684,time);
    J_SUCCt2_2=var(685,time);
    J_SUCCt2_3=var(686,time);
    J_SUCD7=var(687,time);
    J_SUCFUMtdc=var(688,time);
    J_SUCOAS=var(689,time);
    J_SULabc=var(690,time);
    J_SULR=var(691,time);
    J_TAL=var(692,time);
    J_TDPDRE=var(693,time);
    J_TDPDRR=var(694,time);
    J_TDPGDH=var(695,time);
    J_TDSK=var(696,time);
    J_THD2=var(697,time);
    J_THD5=var(698,time);
    J_THDPS=var(699,time);
    J_THMabc=var(700,time);
    J_THMDt2=var(701,time);
    J_THRA=var(702,time);
    J_THRD=var(703,time);
    J_THRD_L=var(704,time);
    J_THRLAD=var(705,time);
    J_THRS=var(706,time);
    J_THRt3=var(707,time);
    J_THRTRS=var(708,time);
    J_THZPSN=var(709,time);
    J_TKT1=var(710,time);
    J_TKT2=var(711,time);
    J_TMAOR3e=var(712,time);
    J_TMDK1=var(713,time);
    J_TMDPP=var(714,time);
    J_TMDS=var(715,time);
    J_TMPKr=var(716,time);
    J_TMPPP=var(717,time);
    J_TPI=var(718,time);
    J_TRDR=var(719,time);
    J_TRPS2=var(720,time);
    J_TRPS3=var(721,time);
    J_TRPt6=var(722,time);
    J_TRPTRS=var(723,time);
    J_TSULabc=var(724,time);
    J_TSULR3=var(725,time);
    J_TSULR4=var(726,time);
    J_TSULST=var(727,time);
    J_TTDCAt2=var(728,time);
    J_TTTNTR3=var(729,time);
    J_TTTNTR4=var(730,time);
    J_TYRt6=var(731,time);
    J_TYRTA=var(732,time);
    J_TYRTRS=var(733,time);
    J_U23GAAT=var(734,time);
    J_UAAGDS=var(735,time);
    J_UAG4E=var(736,time);
    J_UAGAAT=var(737,time);
    J_UAGCVT=var(738,time);
    J_UAGDH=var(739,time);
    J_UAGDP=var(740,time);
    J_UAGPT3=var(741,time);
    J_UAMAGS=var(742,time);
    J_UAMAS=var(743,time);
    J_UAPGR=var(744,time);
    J_UDCPDP=var(745,time);
    J_UDCPDPS=var(746,time);
    J_UDPG4E=var(747,time);
    J_UDPGD=var(748,time);
    J_UGMDDS=var(749,time);
    J_UHGADA=var(750,time);
    J_UMPK=var(751,time);
    J_UNK3=var(752,time);
    J_UPP3MT=var(753,time);
    J_UPP3S=var(754,time);
    J_UPPDC1=var(755,time);
    J_UPPRT=var(756,time);
    J_UQOR=var(757,time);
    J_URAt6=var(758,time);
    J_URCN=var(759,time);
    J_URIDK2=var(760,time);
    J_URIDK3=var(761,time);
    J_URIK1=var(762,time);
    J_URIK2=var(763,time);
    J_URIK3=var(764,time);
    J_URIt2=var(765,time);
    J_URNR3=var(766,time);
    J_URNR4=var(767,time);
    J_USHD=var(768,time);
    J_VALDHr=var(769,time);
    J_VALt4=var(770,time);
    J_VALTA=var(771,time);
    J_VALTRS=var(772,time);
    J_WO4abc=var(773,time);
    J_XPK=var(774,time);
    J_Biomass=var(775,time);
    
    %% calculate biomass
    X(time+1)=X(time)*exp(var(775,time)*1/12);
    
    %% initial value for IDVs
    citr000000	 =1;
    citr100000	 =0;
    citr010000	 =0;
    citr001000	 =0;
    citr000100	 =0;
    citr000010	 =0;
    citr110000	 =0;
    citr101000	 =0;
    citr100100	 =0;
    citr100010	 =0;
    citr011000	 =0;
    citr010100	 =0;
    citr010010	 =0;
    citr001100	 =0;
    citr001010	 =0;
    citr000110	 =0;
    citr111000	 =0;
    citr110100	 =0;
    citr110010	 =0;
    citr101100	 =0;
    citr101010	 =0;
    citr100110	 =0;
    citr011100	 =0;
    citr011010	 =0;
    citr010110	 =0;
    citr001110	 =0;
    citr111100	 =0;
    citr111010	 =0;
    citr110110	 =0;
    citr101110	 =0;
    citr011110	 =0;
    citr111110	 =0;
    citr000001	 =0;
    citr100001	 =0;
    citr000011	 =0;
    citr010001	 =0;
    citr000101	 =0;
    citr001001	 =0;
    citr110001	 =0;
    citr000111	 =0;
    citr101001	 =0;
    citr001011	 =0;
    citr100101	 =0;
    citr010011	 =0;
    citr100011	 =0;
    citr011001	 =0;
    citr001101	 =0;
    citr010101	 =0;
    citr111001	 =0;
    citr001111	 =0;
    citr110101	 =0;
    citr010111	 =0;
    citr110011	 =0;
    citr101101	 =0;
    citr011011	 =0;
    citr101011	 =0;
    citr111101	 =0;
    citr011111	 =0;
    citr011101	 =0;
    citr111011	 =0;
    citr100111	 =0;
    citr110111	 =0;
    citr101111	 =0;
    citr111111	 =0;
    Pyr010	 =1;
    Pyr011	 =0;
    Pyr100	 =0;
    Pyr101	 =0;
    Pyr000	 =0;
    Pyr001	 =0;
    Pyr111	 =0;
    Pyr110	 =0;
    PEP010	 =1;
    PEP011	 =0;
    PEP100	 =0;
    PEP101	 =0;
    PEP000	 =0;
    PEP001	 =0;
    PEP111	 =0;
    PEP110	 =0;
    Oxo00000	 =1;
    Oxo10000	 =0;
    Oxo01000	 =0;
    Oxo00100	 =0;
    Oxo00010	 =0;
    Oxo00001	 =0;
    Oxo11000	 =0;
    Oxo10100	 =0;
    Oxo10010	 =0;
    Oxo10001	 =0;
    Oxo01100	 =0;
    Oxo01010	 =0;
    Oxo01001	 =0;
    Oxo00110	 =0;
    Oxo00101	 =0;
    Oxo00011	 =0;
    Oxo11100	 =0;
    Oxo11010	 =0;
    Oxo11001	 =0;
    Oxo10110	 =0;
    Oxo10101	 =0;
    Oxo10011	 =0;
    Oxo01110	 =0;
    Oxo01101	 =0;
    Oxo01011	 =0;
    Oxo00111	 =0;
    Oxo11110	 =0;
    Oxo11101	 =0;
    Oxo11011	 =0;
    Oxo10111	 =0;
    Oxo01111	 =0;
    Oxo11111	 =0;
    Oxa0000	 =1;
    Oxa0001	 =0;
    Oxa0010	 =0;
    Oxa0011	 =0;
    Oxa0100	 =0;
    Oxa0101	 =0;
    Oxa0110	 =0;
    Oxa0111	 =0;
    Oxa1000	 =0;
    Oxa1001	 =0;
    Oxa1010	 =0;
    Oxa1011	 =0;
    Oxa1100	 =0;
    Oxa1101	 =0;
    Oxa1110	 =0;
    Oxa1111	 =0;
    suc0000	 =1;
    suc0001	 =0;
    suc0010	 =0;
    suc0011	 =0;
    suc0100	 =0;
    suc0101	 =0;
    suc0110	 =0;
    suc0111	 =0;
    suc1000	 =0;
    suc1001	 =0;
    suc1010	 =0;
    suc1011	 =0;
    suc1100	 =0;
    suc1101	 =0;
    suc1110	 =0;
    suc1111	 =0;
    Ma0000	 =1;
    Ma1000	 =0;
    Ma0100	 =0;
    Ma0010	 =0;
    Ma0001	 =0;
    Ma1100	 =0;
    Ma1010	 =0;
    Ma1001	 =0;
    Ma0110	 =0;
    Ma0101	 =0;
    Ma0011	 =0;
    Ma1110	 =0;
    Ma1101	 =0;
    Ma1011	 =0;
    Ma0111	 =0;
    Ma1111	 =0;
    Ace00 	 =1;
    Ace01	 =0;
    Ace10	 =0;
    Ace11 	 =0;

    C13=0;
    C13pool=0;
    Gly00=1;
    Gly01=0;
    Gly10=0;
    Gly11=0;
    Ser000=1;
    Ser001=0;
    Ser010=0;
    Ser011=0;
    Ser100=0;
    Ser101=0;
    Ser110=0;
    Ser111=0;
    smallNum=1e-8;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    exch_v16=exch(1);
    exch_v17=exch(2);
    exch_v18=exch(3);
    exch_v7=exch(4);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    
    
for i=1:40
    
    
    %Balance for citrate
    citr000000=Oxa0000*Ace00;   citr100000=Oxa0001*Ace00;   citr010000=Oxa0010*Ace00;   citr001000=Oxa0100*Ace00;
    citr000100=Oxa0000*Ace01;   citr000010=Oxa0000*Ace10;   citr110000=Oxa0011*Ace00;	citr101000=Oxa0101*Ace00;
    citr100100=Oxa0001*Ace01;   citr100010=Oxa0001*Ace10;   citr011000=Oxa0110*Ace00;   citr010100=Oxa0010*Ace01;
    citr010010=Oxa0010*Ace10;   citr001100=Oxa0100*Ace01;   citr001010=Oxa0100*Ace10;   citr000110=Oxa0000*Ace11;
    citr111000=Oxa0111*Ace00;   citr110100=Oxa0011*Ace01;   citr110010=Oxa0011*Ace10;  	citr101100=Oxa0101*Ace01;
    citr101010=Oxa0101*Ace10;   citr100110=Oxa0001*Ace11;   citr011100=Oxa0110*Ace01;  	citr011010=Oxa0110*Ace10;
    citr010110=Oxa0010*Ace11;  	citr001110=Oxa0100*Ace11;   citr111100=Oxa0111*Ace01;  	citr111010=Oxa0111*Ace10;
    citr110110=Oxa0011*Ace11;   citr101110=Oxa0101*Ace11;   citr011110=Oxa0110*Ace11;  	citr111110=Oxa0111*Ace11;
    
    citr000001=Oxa1000*Ace00;   citr100001=Oxa1001*Ace00;   citr000011=Oxa1000*Ace10;   citr010001=Oxa1010*Ace00;
    citr000101=Oxa1000*Ace01;   citr001001=Oxa1100*Ace00;   citr110001=Oxa1011*Ace00;   citr000111=Oxa1000*Ace11;
    citr101001=Oxa1101*Ace00;   citr001011=Oxa1100*Ace10;   citr100101=Oxa1001*Ace01;   citr010011=Oxa1010*Ace10;
    citr100011=Oxa1001*Ace10;   citr011001=Oxa1110*Ace00;   citr001101=Oxa1100*Ace01;   citr010101=Oxa1010*Ace01;
    citr111001=Oxa1111*Ace00;   citr001111=Oxa1100*Ace11;   citr110101=Oxa1011*Ace01;   citr010111=Oxa1010*Ace11;
    citr110011=Oxa1011*Ace10;  	citr101101=Oxa1101*Ace01;   citr011011=Oxa1110*Ace10;   citr101011=Oxa1101*Ace10;
    citr111101=Oxa1111*Ace01;   citr011111=Oxa1110*Ace11;   citr011101=Oxa1110*Ace01;   citr111011=Oxa1111*Ace10;
    citr100111=Oxa1001*Ace11;   citr110111=Oxa1011*Ace11;   citr101111=Oxa1101*Ace11;   citr111111=Oxa1111*Ace11;
    
    
    %Balance for Oxoglutarate
    Oxo00000=citr000001+citr000000;   Oxo10000=citr100001+citr100000;  Oxo01000=citr010001+citr010000;
    Oxo00100=citr001001+citr001000;   Oxo00010=citr000101+citr000100;  Oxo00001=citr000011+citr000010;
    Oxo11000=citr110001+citr110000;   Oxo10100=citr101001+citr101000;  Oxo10010=citr100101+citr100100;
    Oxo10001=citr100011+citr100010;   Oxo01100=citr011001+citr011000;  Oxo01010=citr010101+citr010100;
    
    Oxo01001=citr010011+citr010010;   Oxo00110=citr001101+citr001100;  Oxo00101=citr001011+citr001010;
    Oxo00011=citr000111+citr000110;   Oxo11100=citr111001+citr111000;  Oxo11010=citr110101+citr110100;
    Oxo11001=citr110011+citr110010;   Oxo10110=citr101101+citr101100;  Oxo10101=citr101011+citr101010;
    
    Oxo10011=citr100111+citr100110;   Oxo01110=citr011101+citr011100;  Oxo01101=citr011011+citr011010;
    Oxo01011=citr010111+citr010110;   Oxo00111=citr001111+citr001110;  Oxo11110=citr111101+citr111100;
    Oxo11101=citr111011+citr111010;   Oxo11011=citr110111+citr110110;  Oxo10111=citr101111+citr101110;
    Oxo01111=citr011111+citr011110;   Oxo11111=citr111111+citr111110;
    
    %Balance for succinate;
    v6=(-J_SUCOAS)*heaviside(-J_SUCOAS-0);
    v10=J_ICL;
    v7_exch=exch_v7/(1-exch_v7);%%Changed
    suc0000=(citr110000+citr100000+citr010000+citr000000)*v10/(v6+v10+v7_exch)+(Oxo10000+Oxo00000)*v6/(v6+v10+v7_exch)+Ma0000*v7_exch/(v6+v10+v7_exch);
    suc1111=(citr011111+citr001111+citr101111+citr111111)*v10/(v6+v10+v7_exch)+Oxo01111*v6/(v6+v10+v7_exch)+Ma1111*v7_exch/(v6+v10+v7_exch);
    suc1000=((citr110001+citr100001+citr000001+citr010001+citr110010+citr100010+citr010010+citr000010)...
        *v10/(v6+v10+v7_exch)+(Oxo11000+Oxo01000+Oxo00001+Oxo10001)*v6/(v6+v10+v7_exch))/2+Ma1000*v7_exch/(v6+v10+v7_exch);
    suc0001=suc1000;
    
    suc0100=((citr111000+citr101000+citr001000+citr011000+citr110100+citr100100+citr010100+citr000100)...
        *v10/(v6+v10+v7_exch)+(Oxo10100+Oxo00100+Oxo00010+Oxo10010)*v6/(v6+v10+v7_exch))/2+Ma0100*v7_exch/(v6+v10+v7_exch);
    suc0010=suc0100;
    
    suc1100=((citr111001+citr101001+citr001001+citr011001+citr110110+citr100110+citr010110+citr000110)...
        *v10/(v6+v10+v7_exch)+(Oxo11100+Oxo01100+Oxo00011+Oxo10011)*v6/(v6+v10+v7_exch))/2+Ma1100*v7_exch/(v6+v10+v7_exch);
    suc0011=suc1100;
    
    suc1010=((citr110101+citr100101+citr000101+citr010101+citr111010+citr101010+citr011010+citr001010)...
        *v10/(v6+v10+v7_exch)+(Oxo11010+Oxo01010+Oxo00101+Oxo10101)*v6/(v6+v10+v7_exch))/2+Ma1010*v7_exch/(v6+v10+v7_exch);
    suc0101=suc1010;
    
    suc1001=(citr110011+citr100011+citr010011+citr000011)*v10/(v6+v10+v7_exch)+(Oxo11001+Oxo01001)*v6/(v6+v10+v7_exch)+Ma1001*v7_exch/(v6+v10+v7_exch);
    suc0110=(citr111100+citr101100+citr011100+citr001100)*v10/(v6+v10+v7_exch)+(Oxo10110+Oxo00110)*v6/(v6+v10+v7_exch)+Ma0110*v7_exch/(v6+v10+v7_exch);
    suc1110=((citr111101+citr101101+citr001101+citr011101+citr111110+citr101110+citr011110+citr001110)...
        *v10/(v6+v10+v7_exch)+(Oxo11110+Oxo01110+Oxo00111+Oxo10111)*v6/(v6+v10+v7_exch))/2+Ma1110*v7_exch/(v6+v10+v7_exch);
    suc0111=suc1110;
    
    suc1101=((citr111011+citr101011+citr001011+citr011011+citr110111+citr100111+citr010111+citr000111)...
        *v10/(v6+v10+v7_exch)+(Oxo11101+Oxo01101+Oxo01011+Oxo11011)*v6/(v6+v10+v7_exch))/2+Ma1101*v7_exch/(v6+v10+v7_exch);
    suc1011=suc1101;
    
    %Balance for glycine
    gly00=citr001111+citr001101+citr001011+citr001110+citr000111+citr001100+citr000011+citr001010...
        +citr001001+citr000101+citr000110+citr001000+citr000100+citr000010+citr000001+citr000000;
    gly01=citr011111+citr011101+citr011011+citr011110+citr010111+citr011100+citr010011+citr011010...
        +citr011001+citr010101+citr010110+citr011000+citr010100+citr010010+citr010001+citr010000;
    gly10=citr101111+citr101101+citr101011+citr101110+citr100111+citr101100+citr100011+citr101010...
        +citr101001+citr100101+citr100110+citr101000+citr100100+citr100010+citr100001+citr100000;
    gly11=citr111111+citr111101+citr111011+citr111110+citr110111+citr111100+citr110011+citr111010...
        +citr111001+citr110101+citr110110+citr111000+citr110100+citr110010+citr110001+citr110000;
    
    %Balance for Malate
    v8=J_FUM+v7_exch;%%Changed
    v11=J_MALS;
    v16=exch_v16/(1-exch_v16);%%Changed
    v9_exch=0;
    
    Ma0000=Oxa0000*v9_exch/(v8+v11+v16+v9_exch)+suc0000*v8/(v8+v11+v16+v9_exch)+gly00*Ace00*v11/(v8+v11+v16+v9_exch)+Pyr000*(1-C13)*v16/(v8+v11+v16+v9_exch);             Ma1000=Oxa1000*v9_exch/(v8+v11+v16+v9_exch)+suc1000*v8/(v8+v11+v16+v9_exch)+gly10*Ace00*v11/(v8+v11+v16+v9_exch)+Pyr100*(1-C13)*v16/(v8+v11+v16+v9_exch);
    Ma0100=Oxa0100*v9_exch/(v8+v11+v16+v9_exch)+suc0100*v8/(v8+v11+v16+v9_exch)+gly01*Ace00*v11/(v8+v11+v16+v9_exch)+Pyr010*(1-C13)*v16/(v8+v11+v16+v9_exch);             Ma0010=Oxa0010*v9_exch/(v8+v11+v16+v9_exch)+suc0010*v8/(v8+v11+v16+v9_exch)+gly00*Ace01*v11/(v8+v11+v16+v9_exch)+Pyr001*(1-C13)*v16/(v8+v11+v16+v9_exch);
    Ma0001=Oxa0001*v9_exch/(v8+v11+v16+v9_exch)+suc0001*v8/(v8+v11+v16+v9_exch)+gly00*Ace10*v11/(v8+v11+v16+v9_exch)+Pyr000*C13*v16/(v8+v11+v16+v9_exch);                 Ma1100=Oxa1100*v9_exch/(v8+v11+v16+v9_exch)+suc1100*v8/(v8+v11+v16+v9_exch)+gly11*Ace00*v11/(v8+v11+v16+v9_exch)+Pyr110*(1-C13)*v16/(v8+v11+v16+v9_exch);
    Ma1010=Oxa1010*v9_exch/(v8+v11+v16+v9_exch)+suc1010*v8/(v8+v11+v16+v9_exch)+gly10*Ace01*v11/(v8+v11+v16+v9_exch)+Pyr101*(1-C13)*v16/(v8+v11+v16+v9_exch);             Ma1001=Oxa1001*v9_exch/(v8+v11+v16+v9_exch)+suc1001*v8/(v8+v11+v16+v9_exch)+gly10*Ace10*v11/(v8+v11+v16+v9_exch)+Pyr100*C13*v16/(v8+v11+v16+v9_exch);
    Ma0110=Oxa0110*v9_exch/(v8+v11+v16+v9_exch)+suc0110*v8/(v8+v11+v16+v9_exch)+gly01*Ace01*v11/(v8+v11+v16+v9_exch)+Pyr011*(1-C13)*v16/(v8+v11+v16+v9_exch);             Ma0101=Oxa0101*v9_exch/(v8+v11+v16+v9_exch)+suc0101*v8/(v8+v11+v16+v9_exch)+gly01*Ace10*v11/(v8+v11+v16+v9_exch)+Pyr010*C13*v16/(v8+v11+v16+v9_exch);
    Ma0011=Oxa0011*v9_exch/(v8+v11+v16+v9_exch)+suc0011*v8/(v8+v11+v16+v9_exch)+gly00*Ace11*v11/(v8+v11+v16+v9_exch)+Pyr001*C13*v16/(v8+v11+v16+v9_exch);                 Ma1110=Oxa1110*v9_exch/(v8+v11+v16+v9_exch)+suc1110*v8/(v8+v11+v16+v9_exch)+gly11*Ace01*v11/(v8+v11+v16+v9_exch)+Pyr111*(1-C13)*v16/(v8+v11+v16+v9_exch);
    Ma1101=Oxa1101*v9_exch/(v8+v11+v16+v9_exch)+suc1101*v8/(v8+v11+v16+v9_exch)+gly11*Ace10*v11/(v8+v11+v16+v9_exch)+Pyr110*C13*v16/(v8+v11+v16+v9_exch);                 Ma1011=Oxa1011*v9_exch/(v8+v11+v16+v9_exch)+suc1011*v8/(v8+v11+v16+v9_exch)+gly10*Ace11*v11/(v8+v11+v16+v9_exch)+Pyr101*C13*v16/(v8+v11+v16+v9_exch);
    Ma0111=Oxa0111*v9_exch/(v8+v11+v16+v9_exch)+suc0111*v8/(v8+v11+v16+v9_exch)+gly01*Ace11*v11/(v8+v11+v16+v9_exch)+Pyr011*C13*v16/(v8+v11+v16+v9_exch);     	          Ma1111=Oxa1111*v9_exch/(v8+v11+v16+v9_exch)+suc1111*v8/(v8+v11+v16+v9_exch)+gly11*Ace11*v11/(v8+v11+v16+v9_exch)+Pyr111*C13*v16/(v8+v11+v16+v9_exch);
    
    
    %Balance for Oxaloacetate
    v9=J_MDH+v9_exch;%%Changed
    v19=J_PPC;
    
    Oxa0000=Ma0000*v9/(v9+v19)+Pyr000*(1-C13)*v19/(v9+v19); Oxa1000=Ma1000*v9/(v9+v19)+Pyr100*(1-C13)*v19/(v9+v19);
    Oxa0100=Ma0100*v9/(v9+v19)+Pyr010*(1-C13)*v19/(v9+v19); Oxa0010=Ma0010*v9/(v9+v19)+Pyr001*(1-C13)*v19/(v9+v19);
    Oxa0001=Ma0001*v9/(v9+v19)+Pyr000*C13*v19/(v9+v19);     Oxa1100=Ma1100*v9/(v9+v19)+Pyr110*(1-C13)*v19/(v9+v19);
    Oxa1010=Ma1010*v9/(v9+v19)+Pyr101*(1-C13)*v19/(v9+v19); Oxa1001=Ma1001*v9/(v9+v19)+Pyr100*C13*v19/(v9+v19);
    Oxa0110=Ma0110*v9/(v9+v19)+Pyr011*(1-C13)*v19/(v9+v19); Oxa0101=Ma0101*v9/(v9+v19)+Pyr010*C13*v19/(v9+v19);
    Oxa0011=Ma0011*v9/(v9+v19)+Pyr001*C13*v19/(v9+v19);     Oxa1110=Ma1110*v9/(v9+v19)+Pyr111*(1-C13)*v19/(v9+v19);
    Oxa1101=Ma1101*v9/(v9+v19)+Pyr110*C13*v19/(v9+v19);     Oxa1011=Ma1011*v9/(v9+v19)+Pyr101*C13*v19/(v9+v19);
    Oxa0111=Ma0111*v9/(v9+v19)+Pyr011*C13*v19/(v9+v19);     Oxa1111=Ma1111*v9/(v9+v19)+Pyr111*C13*v19/(v9+v19);
    
    %Balance for Pyruvate
    v20=J_ME2+v16;%%Changed
    v_pyr_inflow=J_PYRt2*heaviside(J_PYRt2-0);
    v_lact_inflow=J_L_LACD2;
    
    Pyr000=((Ma0001+Ma0000)*v20+PYRext000*v_pyr_inflow+LACText000*v_lact_inflow)/(v20+v_pyr_inflow+v_lact_inflow);
    Pyr001=((Ma0010+Ma0011)*v20+PYRext001*v_pyr_inflow+LACText001*v_lact_inflow)/(v20+v_pyr_inflow+v_lact_inflow);
    Pyr010=((Ma0101+Ma0100)*v20+PYRext010*v_pyr_inflow+LACText010*v_lact_inflow)/(v20+v_pyr_inflow+v_lact_inflow);
    Pyr100=((Ma1001+Ma1000)*v20+PYRext100*v_pyr_inflow+LACText100*v_lact_inflow)/(v20+v_pyr_inflow+v_lact_inflow);
    Pyr110=((Ma1101+Ma1100)*v20+PYRext110*v_pyr_inflow+LACText110*v_lact_inflow)/(v20+v_pyr_inflow+v_lact_inflow);
    Pyr101=((Ma1011+Ma1010)*v20+PYRext101*v_pyr_inflow+LACText101*v_lact_inflow)/(v20+v_pyr_inflow+v_lact_inflow);
    Pyr011=((Ma0111+Ma0110)*v20+PYRext011*v_pyr_inflow+LACText011*v_lact_inflow)/(v20+v_pyr_inflow+v_lact_inflow);
    Pyr111=((Ma1111+Ma1110)*v20+PYRext111*v_pyr_inflow+LACText111*v_lact_inflow)/(v20+v_pyr_inflow+v_lact_inflow);
    
    %Balance for PEP
    v15=J_PPCK;
    v21=J_PPS;
    
    PEP000=(Oxa0001+Oxa0000)*v15/(v15+v21)+Pyr000*v21/(v15+v21);
    PEP001=(Oxa0010+Oxa0011)*v15/(v15+v21)+Pyr001*v21/(v15+v21);
    PEP010=(Oxa0101+Oxa0100)*v15/(v15+v21)+Pyr010*v21/(v15+v21);
    PEP100=(Oxa1001+Oxa1000)*v15/(v15+v21)+Pyr100*v21/(v15+v21);
    PEP110=(Oxa1101+Oxa1100)*v15/(v15+v21)+Pyr110*v21/(v15+v21);
    PEP101=(Oxa1011+Oxa1010)*v15/(v15+v21)+Pyr101*v21/(v15+v21);
    PEP011=(Oxa0111+Oxa0110)*v15/(v15+v21)+Pyr011*v21/(v15+v21);
    PEP111=(Oxa1111+Oxa1110)*v15/(v15+v21)+Pyr111*v21/(v15+v21);
    
    %Balance for intracellular acetate    
    v_act_inflow=J_ACt6*heaviside(J_ACt6-0);
    v2=J_PDH+smallNum;
    
    Ace00=((Pyr000+Pyr100)*v2+ACText00*v_act_inflow)/(v2+v_act_inflow);
    Ace01=((Pyr001+Pyr101)*v2+ACText01*v_act_inflow)/(v2+v_act_inflow);
    Ace10=((Pyr010+Pyr110)*v2+ACText10*v_act_inflow)/(v2+v_act_inflow);
    Ace11=((Pyr011+Pyr111)*v2+ACText11*v_act_inflow)/(v2+v_act_inflow);
    
    
    %Balance for glycine
    v17=exch_v17/(1-exch_v17);
    v18=exch_v18/(1-exch_v18);
    v13=J_GHMT*heaviside(J_GHMT-0)+v17;
    v14=J_GLYCL+v18;
    Gly00=((Ser000+Ser001)*v13+(1-C13)*(1-C13pool)*v18)/(v13+v18);
    Gly01=((Ser010+Ser011)*v13+(1-C13)*C13pool*v18)/(v13+v18);
    Gly10=((Ser100+Ser101)*v13+C13*(1-C13pool)*v18)/(v13+v18);
    Gly11=((Ser110+Ser111)*v13+C13*C13pool*v18)/(v13+v18);
    
    %Balance for serine
    v12=J_PSP_L;
    Ser000=(PEP000*v12+Gly00*(1-C13pool)*v17)/(v12+v17);
    Ser001=(PEP001*v12+Gly00*(C13pool)*v17)/(v12+v17);
    Ser010=(PEP010*v12+Gly01*(1-C13pool)*v17)/(v12+v17);
    Ser011=(PEP011*v12+Gly01*(C13pool)*v17)/(v12+v17);
    Ser100=(PEP100*v12+Gly10*(1-C13pool)*v17)/(v12+v17);
    Ser101=(PEP101*v12+Gly10*(C13pool)*v17)/(v12+v17);
    Ser110=(PEP110*v12+Gly11*(1-C13pool)*v17)/(v12+v17);
    Ser111=(PEP111*v12+Gly11*(C13pool)*v17)/(v12+v17);
    
    %Balance for C13pool
    C13pool=((PEP001+PEP011+PEP101+PEP111)*v13+(PEP010+PEP011+PEP110+PEP111)*v14)/(v13+v14);
    
    %Balance for C13
    v2=J_PDH+smallNum;
    v5=J_ICDHy;
    v6=(-J_SUCOAS);
    v20=J_ME2+v16;%%Changed
    v15=J_PPCK;
    v_co2_inflow=(J_CO2t)*heaviside(J_CO2t-0);
    
    C13=(v2*(Pyr100+Pyr101+Pyr110+Pyr111)+...
        v5*(citr000001+citr000011+citr000101+citr000111+citr001001+citr001011+citr001101+citr001111+citr010001+citr010011+citr010101+citr010111+citr011001+citr011011+citr011101+citr011111+citr100001+citr100011+citr100101+citr100111+citr101001+citr101011+citr101101+citr101111+citr110001+citr110011+citr110101+citr110111+citr111001+citr111011+citr111101+citr111111)+...
        v6*(Oxo10000+Oxo10001+Oxo10010+Oxo10011+Oxo10100+Oxo10101+Oxo10110+Oxo10111+Oxo11000+Oxo11001+Oxo11010+Oxo11011+Oxo11100+Oxo11101+Oxo11110+Oxo11111)+...
        v20*(Ma0001+Ma0011+Ma0101+Ma0111+Ma1001+Ma1011+Ma1101+Ma1111)+...
        v15*(Oxa0001+Oxa0011+Oxa0101+Oxa0111+Oxa1001+Oxa1011+Oxa1101+Oxa1111)+...
        v_co2_inflow*(0.011))/(v2+v5+v6+v20+v15+v_co2_inflow);
        
    
    %Correction for rounding errors
    totalCIT=citr000000+ citr000001+ citr000010+ citr000011+ citr000100+ citr000101+ citr000110+ citr000111+ citr001000+ citr001001+ citr001010+ citr001011+ citr001100+ citr001101+ citr001110+ citr001111+ citr010000+ citr010001+ citr010010+ citr010011+ citr010100+ citr010101+ citr010110+ citr010111+ citr011000+ citr011001+ citr011010+ citr011011+ citr011100+ citr011101+ citr011110+ citr011111+ citr100000+ citr100001+ citr100010+ citr100011+ citr100100+ citr100101+ citr100110+ citr100111+ citr101000+ citr101001+ citr101010+ citr101011+ citr101100+ citr101101+ citr101110+ citr101111+ citr110000+ citr110001+ citr110010+ citr110011+ citr110100+ citr110101+ citr110110+ citr110111+ citr111000+ citr111001+ citr111010+ citr111011+ citr111100+ citr111101+ citr111110+ citr111111   ;
    totalPYR=Pyr000+ Pyr001+ Pyr010+ Pyr011+ Pyr100+ Pyr101+ Pyr110+ Pyr111   ;
    totalPEP=PEP000+ PEP001+ PEP010+ PEP011+ PEP100+ PEP101+ PEP110+ PEP111   ;
    totalOxo=Oxo00000+ Oxo00001+ Oxo00010+ Oxo00011+ Oxo00100+ Oxo00101+ Oxo00110+ Oxo00111+ Oxo01000+ Oxo01001+ Oxo01010+ Oxo01011+ Oxo01100+ Oxo01101+ Oxo01110+ Oxo01111+ Oxo10000+ Oxo10001+ Oxo10010+ Oxo10011+ Oxo10100+ Oxo10101+ Oxo10110+ Oxo10111+ Oxo11000+ Oxo11001+ Oxo11010+ Oxo11011+ Oxo11100+ Oxo11101+ Oxo11110+ Oxo11111   ;
    totalOxa=Oxa0000+ Oxa0001+ Oxa0010+ Oxa0011+ Oxa0100+ Oxa0101+ Oxa0110+ Oxa0111+ Oxa1000+ Oxa1001+ Oxa1010+ Oxa1011+ Oxa1100+ Oxa1101+ Oxa1110+ Oxa1111   ;
    totalSUC=suc0000+ suc0001+ suc0010+ suc0011+ suc0100+ suc0101+ suc0110+ suc0111+ suc1000+ suc1001+ suc1010+ suc1011+ suc1100+ suc1101+ suc1110+ suc1111   ;
    totalMA=Ma0000+ Ma0001+ Ma0010+ Ma0011+ Ma0100+ Ma0101+ Ma0110+ Ma0111+ Ma1000+ Ma1001+ Ma1010+ Ma1011+ Ma1100+ Ma1101+ Ma1110+ Ma1111  ;
    totalAce=Ace00+ Ace01+ Ace10+ Ace11;
    
    Oxa0000=Oxa0000/totalOxa;           Oxa0001=Oxa0001/totalOxa;           Oxa0010=Oxa0010/totalOxa;      Oxa0011=Oxa0011/totalOxa;
    Oxa0100=Oxa0100/totalOxa;           Oxa0101=Oxa0101/totalOxa;           Oxa0110=Oxa0110/totalOxa;      Oxa0111=Oxa0111/totalOxa;
    Oxa1000=Oxa1000/totalOxa;           Oxa1001=Oxa1001/totalOxa;           Oxa1010=Oxa1010/totalOxa;      Oxa1011=Oxa1011/totalOxa;
    Oxa1100=Oxa1100/totalOxa;           Oxa1101=Oxa1101/totalOxa;           Oxa1110=Oxa1110/totalOxa;      Oxa1111=Oxa1111/totalOxa;
    citr000000=citr000000/totalCIT;
    citr100000=citr100000/totalCIT;
    citr010000=citr010000/totalCIT;
    citr001000=citr001000/totalCIT;
    citr000100=citr000100/totalCIT;
    citr000010=citr000010/totalCIT;
    citr110000=citr110000/totalCIT;
    citr101000=citr101000/totalCIT;
    citr100100=citr100100/totalCIT;
    citr100010=citr100010/totalCIT;
    citr011000=citr011000/totalCIT;
    citr010100=citr010100/totalCIT;
    citr010010=citr010010/totalCIT;
    citr001100=citr001100/totalCIT;
    citr001010=citr001010/totalCIT;
    citr000110=citr000110/totalCIT;
    citr111000=citr111000/totalCIT;
    citr110100=citr110100/totalCIT;
    citr110010=citr110010/totalCIT;
    citr101100=citr101100/totalCIT;
    citr101010=citr101010/totalCIT;
    citr100110=citr100110/totalCIT;
    citr011100=citr011100/totalCIT;
    citr011010=citr011010/totalCIT;
    citr010110=citr010110/totalCIT;
    citr001110=citr001110/totalCIT;
    citr111100=citr111100/totalCIT;
    citr111010=citr111010/totalCIT;
    citr110110=citr110110/totalCIT;
    citr101110=citr101110/totalCIT;
    citr011110=citr011110/totalCIT;
    citr111110=citr111110/totalCIT;
    
    citr000001=citr000001/totalCIT;
    citr100001=citr100001/totalCIT;
    citr010001=citr010001/totalCIT;
    citr001001=citr001001/totalCIT;
    citr000101=citr000101/totalCIT;
    citr000011=citr000011/totalCIT;
    citr110001=citr110001/totalCIT;
    citr101001=citr101001/totalCIT;
    citr100101=citr100101/totalCIT;
    citr100011=citr100011/totalCIT;
    citr011001=citr011001/totalCIT;
    citr010101=citr010101/totalCIT;
    citr010011=citr010011/totalCIT;
    citr001101=citr001101/totalCIT;
    citr001011=citr001011/totalCIT;
    citr000111=citr000111/totalCIT;
    citr111001=citr111001/totalCIT;
    citr110101=citr110101/totalCIT;
    citr110011=citr110011/totalCIT;
    citr101101=citr101101/totalCIT;
    citr101011=citr101011/totalCIT;
    citr100111=citr100111/totalCIT;
    citr011101=citr011101/totalCIT;
    citr011011=citr011011/totalCIT;
    citr010111=citr010111/totalCIT;
    citr001111=citr001111/totalCIT;
    citr111101=citr111101/totalCIT;
    citr111011=citr111011/totalCIT;
    citr110111=citr110111/totalCIT;
    citr101111=citr101111/totalCIT;
    citr011111=citr011111/totalCIT;
    citr111111=citr111111/totalCIT;
    
    Oxo00000=Oxo00000/totalOxo;   Oxo10000=Oxo10000/totalOxo;  Oxo01000=Oxo01000/totalOxo;
    Oxo00100=Oxo00100/totalOxo;   Oxo00010=Oxo00010/totalOxo;  Oxo00001=Oxo00001/totalOxo;
    Oxo11000=Oxo11000/totalOxo;   Oxo10100=Oxo10100/totalOxo;  Oxo10010=Oxo10010/totalOxo;
    Oxo10001=Oxo10001/totalOxo;   Oxo01100=Oxo01100/totalOxo;  Oxo01010=Oxo01010/totalOxo;
    Oxo01001=Oxo01001/totalOxo;   Oxo00110=Oxo00110/totalOxo;  Oxo00101=Oxo00101/totalOxo;
    Oxo00011=Oxo00011/totalOxo;   Oxo11100=Oxo11100/totalOxo;  Oxo11010=Oxo11010/totalOxo;
    Oxo11001=Oxo11001/totalOxo;   Oxo10110=Oxo10110/totalOxo;  Oxo10101=Oxo10101/totalOxo;
    Oxo10011=Oxo10011/totalOxo;   Oxo01110=Oxo01110/totalOxo;  Oxo01101=Oxo01101/totalOxo;
    Oxo01011=Oxo01011/totalOxo;   Oxo00111=Oxo00111/totalOxo;  Oxo11110=Oxo11110/totalOxo;
    Oxo11101=Oxo11101/totalOxo;   Oxo11011=Oxo11011/totalOxo;  Oxo10111=Oxo10111/totalOxo;
    Oxo01111=Oxo01111/totalOxo;   Oxo11111=Oxo11111/totalOxo;
    
    suc0000=suc0000/totalSUC;
    suc0001=suc0001/totalSUC;
    suc0010=suc0010/totalSUC;
    suc0011=suc0011/totalSUC;
    suc0100=suc0100/totalSUC;
    suc0101=suc0101/totalSUC;
    suc0110=suc0110/totalSUC;
    suc0111=suc0111/totalSUC;
    suc1000=suc1000/totalSUC;
    suc1001=suc1001/totalSUC;
    suc1010=suc1010/totalSUC;
    suc1011=suc1011/totalSUC;
    suc1100=suc1100/totalSUC;
    suc1101=suc1101/totalSUC;
    suc1110=suc1110/totalSUC;
    suc1111=suc1111/totalSUC;
    Ma0000=Ma0000/totalMA;           Ma0001=Ma0001/totalMA;           Ma0010=Ma0010/totalMA;      Ma0011=Ma0011/totalMA;
    Ma0100=Ma0100/totalMA;           Ma0101=Ma0101/totalMA;           Ma0110=Ma0110/totalMA;      Ma0111=Ma0111/totalMA;
    Ma1000=Ma1000/totalMA;           Ma1001=Ma1001/totalMA;           Ma1010=Ma1010/totalMA;      Ma1011=Ma1011/totalMA;
    Ma1100=Ma1100/totalMA;           Ma1101=Ma1101/totalMA;           Ma1110=Ma1110/totalMA;      Ma1111=Ma1111/totalMA;
    Ace00=Ace00/totalAce; Ace01=Ace01/totalAce; Ace10=Ace10/totalAce; Ace11=Ace11/totalAce;
    Pyr000=Pyr000/totalPYR;  Pyr001=Pyr001/totalPYR; Pyr010=Pyr010/totalPYR; Pyr011=Pyr011/totalPYR;
    Pyr100=Pyr100/totalPYR;  Pyr101=Pyr101/totalPYR; Pyr110=Pyr110/totalPYR; Pyr111=Pyr111/totalPYR;
    PEP000=PEP000/totalPEP;  PEP001=PEP001/totalPEP; PEP010=PEP010/totalPEP; PEP011=PEP011/totalPEP;
    PEP100=PEP100/totalPEP;  PEP101=PEP101/totalPEP; PEP110=PEP110/totalPEP; PEP111=PEP111/totalPEP;
    
    
  
    
    %Calculate MDV of amino acids
    
    MDV_AKG_M0=Oxo00000;
    MDV_AKG_M1=Oxo10000+Oxo01000+Oxo00100+Oxo00010+Oxo00001;
    MDV_AKG_M2=Oxo11000+Oxo10100+Oxo10010+Oxo10001+Oxo01100+Oxo01010+Oxo01001+Oxo00110+Oxo00101+Oxo00011;
    MDV_AKG_M3=Oxo11100+Oxo11010+Oxo11001+Oxo10110+Oxo10101+Oxo10011+Oxo01110+Oxo01101+Oxo01011+Oxo00111;
    MDV_AKG_M4=Oxo11110+Oxo11011+Oxo11101+Oxo10111+Oxo01111;
    MDV_AKG_M5=Oxo11111;
    
    MDV_OAA_M0=Oxa0000;
    MDV_OAA_M1=Oxa1000+Oxa0100+Oxa0010+Oxa0001;
    MDV_OAA_M2=Oxa1100+Oxa1010+Oxa1001+Oxa0110+Oxa0101+Oxa0011;
    MDV_OAA_M3=Oxa1110+Oxa1011+Oxa1101+Oxa0111;
    MDV_OAA_M4=Oxa1111;
    
    MDV_PYR_M0=Pyr000;
    MDV_PYR_M1=Pyr100+Pyr010+Pyr001;
    MDV_PYR_M2=Pyr110+Pyr101+Pyr011;
    MDV_PYR_M3=Pyr111;
    
    MDV_Ser_M0=Ser000;
    MDV_Ser_M1=Ser100+Ser010+Ser001;
    MDV_Ser_M2=Ser110+Ser101+Ser011;
    MDV_Ser_M3=Ser111;
    
    MDV_Gly_M0=Gly00;
    MDV_Gly_M1=Gly01+Gly10;
    MDV_Gly_M2=Gly11;
    
    
    MDV_Glu159_M0=Oxo00000+Oxo10000;
    MDV_Glu159_M1=Oxo11000+Oxo01000+Oxo00100+Oxo10100+Oxo00010+Oxo10010+Oxo00001+Oxo10001;
    MDV_Glu159_M2=Oxo11100+Oxo01100+Oxo00110+Oxo10110+Oxo00011+Oxo10011+Oxo01001+Oxo11001+Oxo01010+Oxo11010+Oxo00101+Oxo10101;
    MDV_Glu159_M3=Oxo01101+Oxo11101+Oxo01110+Oxo11110+Oxo01011+Oxo11011+Oxo00111+Oxo10111;
    
    MDV_Asp159_M0=Oxa0000+Oxa1000;
    MDV_Asp159_M1=Oxa0100+Oxa1100+Oxa0010+Oxa1010+Oxa0001+Oxa1001;
    MDV_Asp159_M2=Oxa0110+Oxa1110+Oxa0011+Oxa1011+Oxa0101+Oxa1101;
    MDV_Asp159_M3=Oxa0111+Oxa1111;
    
    MDV_ser159_M0=PEP000+PEP100;
    MDV_ser159_M1=PEP001+PEP101+PEP010+PEP110;
    MDV_ser159_M2=PEP011+PEP111;
    
    MDV_ala159_M0=Pyr000+Pyr100;
    MDV_ala159_M1=Pyr001+Pyr101+Pyr010+Pyr110;
    MDV_ala159_M2=Pyr011+Pyr111;
    
    MDV_gly159=PEP010+PEP111+PEP011+PEP110;
    
    MDV_Leu159_M0=(Ace00 + Ace10)*(Pyr100 + Pyr000)^2;
    MDV_Leu159_M1=((Ace00 + Ace10)*(Pyr110 + Pyr010 + Pyr101 + Pyr001)*(Pyr100 + Pyr000)*2 + (Ace11 + Ace01)*(Pyr100 + Pyr000)^2);
    MDV_Leu159_M2=((Ace00 + Ace10)*(Pyr111 + Pyr011)*(Pyr100 + Pyr000)*2 + (Ace00 + Ace10)*(Pyr110 + Pyr010 + Pyr101 + Pyr001)^2 + (Ace01 + Ace11)*(Pyr110 + Pyr010 + Pyr101 + Pyr001)*(Pyr000 + Pyr100)*2);
    MDV_Leu159_M3=((Ace00 + Ace10)*(Pyr110 + Pyr010 + Pyr101 + Pyr001)*(Pyr011 + Pyr111)*2 + (Ace01 + Ace11)*(Pyr100 + Pyr000)*(Pyr011 + Pyr111)*2 + (Ace01 + Ace11)*(Pyr110 + Pyr010 + Pyr101 + Pyr001)^2);
    
    
    
end




%% calculate IDV for all the extracellular metabolites
if(-J_PYRt2>0)
    sum_flux_pyr=sum_flux_pyr+(-J_PYRt2)*(X(time+1)-X(time));
    sum_isotope_pyr000=sum_isotope_pyr000+(-J_PYRt2)*(X(time+1)-X(time))*Pyr000;
    sum_isotope_pyr001=sum_isotope_pyr001+(-J_PYRt2)*(X(time+1)-X(time))*Pyr001;
    sum_isotope_pyr010=sum_isotope_pyr010+(-J_PYRt2)*(X(time+1)-X(time))*Pyr010;
    sum_isotope_pyr011=sum_isotope_pyr011+(-J_PYRt2)*(X(time+1)-X(time))*Pyr011;
    sum_isotope_pyr100=sum_isotope_pyr100+(-J_PYRt2)*(X(time+1)-X(time))*Pyr100;
    sum_isotope_pyr101=sum_isotope_pyr101+(-J_PYRt2)*(X(time+1)-X(time))*Pyr101;
    sum_isotope_pyr110=sum_isotope_pyr110+(-J_PYRt2)*(X(time+1)-X(time))*Pyr110;
    sum_isotope_pyr111=sum_isotope_pyr111+(-J_PYRt2)*(X(time+1)-X(time))*Pyr111;
    PYRext000=sum_isotope_pyr000/sum_flux_pyr;
    PYRext001=sum_isotope_pyr001/sum_flux_pyr;
    PYRext010=sum_isotope_pyr010/sum_flux_pyr;
    PYRext011=sum_isotope_pyr011/sum_flux_pyr;
    PYRext100=sum_isotope_pyr100/sum_flux_pyr;
    PYRext101=sum_isotope_pyr101/sum_flux_pyr;
    PYRext110=sum_isotope_pyr011/sum_flux_pyr;
    PYRext111=sum_isotope_pyr111/sum_flux_pyr;
end
if(-J_ACt6>0)
    sum_flux_act=sum_flux_act+(-J_ACt6)*(X(time+1)-X(time));
    sum_isotope_act00=sum_isotope_act00+(-J_ACt6)*(X(time+1)-X(time))*Ace00;
    sum_isotope_act01=sum_isotope_act01+(-J_ACt6)*(X(time+1)-X(time))*Ace01;
    sum_isotope_act10=sum_isotope_act10+(-J_ACt6)*(X(time+1)-X(time))*Ace10;
    sum_isotope_act11=sum_isotope_act11+(-J_ACt6)*(X(time+1)-X(time))*Ace11;
    ACText00=sum_isotope_act00/sum_flux_act;
    ACText01=sum_isotope_act01/sum_flux_act;
    ACText10=sum_isotope_act10/sum_flux_act;
    ACText11=sum_isotope_act11/sum_flux_act;
end

sum_flux_ser=sum_flux_ser+(X(time+1)-X(time));
sum_isotope_SerM0=sum_isotope_SerM0+(X(time+1)-X(time))*MDV_Ser_M0;
sum_isotope_SerM1=sum_isotope_SerM1+(X(time+1)-X(time))*MDV_Ser_M1;
sum_isotope_SerM2=sum_isotope_SerM2+(X(time+1)-X(time))*MDV_Ser_M2;
sum_isotope_SerM3=sum_isotope_SerM3+(X(time+1)-X(time))*MDV_Ser_M3;
sum_isotope_Ser159M0=sum_isotope_Ser159M0+(X(time+1)-X(time))*MDV_ser159_M0;
sum_isotope_Ser159M1=sum_isotope_Ser159M1+(X(time+1)-X(time))*MDV_ser159_M1;
sum_isotope_Ser159M2=sum_isotope_Ser159M2+(X(time+1)-X(time))*MDV_ser159_M2;
Ser_M0=sum_isotope_SerM0/sum_flux_ser;
Ser_M1=sum_isotope_SerM1/sum_flux_ser;
Ser_M2=sum_isotope_SerM2/sum_flux_ser;
Ser_M3=sum_isotope_SerM3/sum_flux_ser;




sum_flux_ala=sum_flux_ala+(X(time+1)-X(time));
sum_isotope_AlaM0=sum_isotope_AlaM0+(X(time+1)-X(time))*MDV_PYR_M0;
sum_isotope_AlaM1=sum_isotope_AlaM1+(X(time+1)-X(time))*MDV_PYR_M1;
sum_isotope_AlaM2=sum_isotope_AlaM2+(X(time+1)-X(time))*MDV_PYR_M2;
sum_isotope_AlaM3=sum_isotope_AlaM3+(X(time+1)-X(time))*MDV_PYR_M3;
sum_isotope_Ala159M0=sum_isotope_Ala159M0+(X(time+1)-X(time))*MDV_ala159_M0;
sum_isotope_Ala159M1=sum_isotope_Ala159M1+(X(time+1)-X(time))*MDV_ala159_M1;
sum_isotope_Ala159M2=sum_isotope_Ala159M2+(X(time+1)-X(time))*MDV_ala159_M2;
Ala_M0=sum_isotope_AlaM0/sum_flux_ala;
Ala_M1=sum_isotope_AlaM1/sum_flux_ala;
Ala_M2=sum_isotope_AlaM2/sum_flux_ala;
Ala_M3=sum_isotope_AlaM3/sum_flux_ala;



sum_flux_leu=sum_flux_leu+(X(time+1)-X(time));
sum_isotope_Leu159M0=sum_isotope_Leu159M0+(X(time+1)-X(time))*MDV_Leu159_M0;
sum_isotope_Leu159M1=sum_isotope_Leu159M1+(X(time+1)-X(time))*MDV_Leu159_M1;
sum_isotope_Leu159M2=sum_isotope_Leu159M2+(X(time+1)-X(time))*MDV_Leu159_M2;
sum_isotope_Leu159M3=sum_isotope_Leu159M3+(X(time+1)-X(time))*MDV_Leu159_M3;



sum_flux_asp=sum_flux_asp+(X(time+1)-X(time));
sum_isotope_AspM0=sum_isotope_AspM0+(X(time+1)-X(time))*MDV_OAA_M0;
sum_isotope_AspM1=sum_isotope_AspM1+(X(time+1)-X(time))*MDV_OAA_M1;
sum_isotope_AspM2=sum_isotope_AspM2+(X(time+1)-X(time))*MDV_OAA_M2;
sum_isotope_AspM3=sum_isotope_AspM3+(X(time+1)-X(time))*MDV_OAA_M3;
sum_isotope_AspM4=sum_isotope_AspM4+(X(time+1)-X(time))*MDV_OAA_M4;
sum_isotope_Asp159M0=sum_isotope_Asp159M0+(X(time+1)-X(time))*MDV_Asp159_M0;
sum_isotope_Asp159M1=sum_isotope_Asp159M1+(X(time+1)-X(time))*MDV_Asp159_M1;
sum_isotope_Asp159M2=sum_isotope_Asp159M2+(X(time+1)-X(time))*MDV_Asp159_M2;
sum_isotope_Asp159M3=sum_isotope_Asp159M3+(X(time+1)-X(time))*MDV_Asp159_M3;
Asp_M0=sum_isotope_AspM0/sum_flux_asp;
Asp_M1=sum_isotope_AspM1/sum_flux_asp;
Asp_M2=sum_isotope_AspM2/sum_flux_asp;
Asp_M3=sum_isotope_AspM3/sum_flux_asp;
Asp_M4=sum_isotope_AspM4/sum_flux_asp;



sum_flux_glu=sum_flux_glu+(X(time+1)-X(time));
sum_isotope_GluM0=sum_isotope_GluM0+(X(time+1)-X(time))*MDV_AKG_M0;
sum_isotope_GluM1=sum_isotope_GluM1+(X(time+1)-X(time))*MDV_AKG_M1;
sum_isotope_GluM2=sum_isotope_GluM2+(X(time+1)-X(time))*MDV_AKG_M2;
sum_isotope_GluM3=sum_isotope_GluM3+(X(time+1)-X(time))*MDV_AKG_M3;
sum_isotope_GluM4=sum_isotope_GluM4+(X(time+1)-X(time))*MDV_AKG_M4;
sum_isotope_GluM5=sum_isotope_GluM5+(X(time+1)-X(time))*MDV_AKG_M5;
sum_isotope_Glu159M0=sum_isotope_Glu159M0+(X(time+1)-X(time))*MDV_Glu159_M0;
sum_isotope_Glu159M1=sum_isotope_Glu159M1+(X(time+1)-X(time))*MDV_Glu159_M1;
sum_isotope_Glu159M2=sum_isotope_Glu159M2+(X(time+1)-X(time))*MDV_Glu159_M2;
sum_isotope_Glu159M3=sum_isotope_Glu159M3+(X(time+1)-X(time))*MDV_Glu159_M3;
Glu_M0=sum_isotope_GluM0/sum_flux_glu;
Glu_M1=sum_isotope_GluM1/sum_flux_glu;
Glu_M2=sum_isotope_GluM2/sum_flux_glu;
Glu_M3=sum_isotope_GluM3/sum_flux_glu;
Glu_M4=sum_isotope_GluM4/sum_flux_glu;
Glu_M5=sum_isotope_GluM5/sum_flux_glu;






sum_flux_gly=sum_flux_gly+(X(time+1)-X(time));
sum_isotope_GlyM0=sum_isotope_GlyM0+(X(time+1)-X(time))*MDV_Gly_M0;
sum_isotope_GlyM1=sum_isotope_GlyM1+(X(time+1)-X(time))*MDV_Gly_M1;
sum_isotope_GlyM2=sum_isotope_GlyM2+(X(time+1)-X(time))*MDV_Gly_M2;
sum_isotope_Gly159=sum_isotope_Gly159+(X(time+1)-X(time))*MDV_gly159;
Gly_M0=sum_isotope_GlyM0/sum_flux_gly;
Gly_M1=sum_isotope_GlyM1/sum_flux_gly;
Gly_M2=sum_isotope_GlyM2/sum_flux_gly;





exIDV_ACT(1,time)=ACText00;
exIDV_ACT(2,time)=ACText01;
exIDV_ACT(3,time)=ACText10;
exIDV_ACT(4,time)=ACText11;
exIDV_PYR(1,time)=PYRext000;
exIDV_PYR(2,time)=PYRext001;
exIDV_PYR(3,time)=PYRext010;
exIDV_PYR(4,time)=PYRext011;
exIDV_PYR(5,time)=PYRext100;
exIDV_PYR(6,time)=PYRext101;
exIDV_PYR(7,time)=PYRext110;
exIDV_PYR(8,time)=PYRext111;

exIDV_Ala(1,time)=Ala_M0;
exIDV_Ala(2,time)=Ala_M1;
exIDV_Ala(3,time)=Ala_M2;
exIDV_Ala(4,time)=Ala_M3;


exIDV_Ser(1,time)=Ser_M0;
exIDV_Ser(2,time)=Ser_M1;
exIDV_Ser(3,time)=Ser_M2;
exIDV_Ser(4,time)=Ser_M3;

exIDV_Gly(1,time)=Gly_M0;
exIDV_Gly(2,time)=Gly_M1;
exIDV_Gly(3,time)=Gly_M2;


exIDV_Asp(1,time)=Asp_M0;
exIDV_Asp(2,time)=Asp_M1;
exIDV_Asp(3,time)=Asp_M2;
exIDV_Asp(4,time)=Asp_M3;
exIDV_Asp(5,time)=Asp_M4;


exIDV_Glu(1,time)=Glu_M0;
exIDV_Glu(2,time)=Glu_M1;
exIDV_Glu(3,time)=Glu_M2;
exIDV_Glu(4,time)=Glu_M3;
exIDV_Glu(5,time)=Glu_M4;
exIDV_Glu(6,time)=Glu_M5;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

end
time_early=288; %24hr
time_late=336;  %28hr
MDV_Ala_Early=[0.0685000000000000;0.904700000000000;0.0248000000000000;0.00200000000000000;];
MDV_Ser_Early=[0.151600000000000;0.655100000000000;0.148900000000000;0.0444000000000000;];
MDV_Asp_Early=[0.0724000000000000;0.234300000000000;0.372900000000000;0.312500000000000;0.00790000000000000;];
MDV_Glu_Early=[0.0542000000000000;0.0131000000000000;0.326900000000000;0.436500000000000;0.166500000000000;0.00280000000000000;];
MDV_Gly_Early=[0.627700000000000;0.286800000000000;0.0855000000000000;];

MDV_Ala_Late=[0.0642000000000000;0.834100000000000;0.0696000000000000;0.0321000000000000;];
MDV_Ser_Late=[0.128000000000000;0.586800000000000;0.205800000000000;0.0794000000000000;];
MDV_Asp_Late=[0.0552000000000000;0.193000000000000;0.349900000000000;0.379500000000000;0.0223000000000000;];
MDV_Glu_Late=[0.0420000000000000;0.0108000000000000;0.257300000000000;0.470200000000000;0.218300000000000;0.00130000000000000;];
MDV_Gly_Late=[0.525500000000000;0.334200000000000;0.140300000000000;];

f_early= sum((exIDV_Ala(:,time_early)-MDV_Ala_Early(:,1)).^2)+...
    sum((exIDV_Ser(:,time_early)-MDV_Ser_Early(:,1)).^2)+...
    sum((exIDV_Asp(:,time_early)-MDV_Asp_Early(:,1)).^2)+...
    sum((exIDV_Glu(:,time_early)-MDV_Glu_Early(:,1)).^2)+...
    sum((exIDV_Gly(:,time_early)-MDV_Gly_Early(:,1)).^2);

f_late= sum((exIDV_Ala(:,time_late)-MDV_Ala_Late(:,1)).^2)+...
    sum((exIDV_Ser(:,time_late)-MDV_Ser_Late(:,1)).^2)+...
    sum((exIDV_Asp(:,time_late)-MDV_Asp_Late(:,1)).^2)+...
    sum((exIDV_Glu(:,time_late)-MDV_Glu_Late(:,1)).^2)+...
    sum((exIDV_Gly(:,time_late)-MDV_Gly_Late(:,1)).^2);
f=f_early+f_late;
end